require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

function MakeCustomer(customer, x, y)
    -- customer description x offset:
    kTextOffX = 40;
    return Group(
        {
            SetStyle(CreateTextStyle(FontHelp, 26, DarkRedColor)),
            Text
            {
                x=x+kTextOffX,
                y=y-50,
                w = 240,
                h = 30,
                label=GetString("customer_name", customer),
                flags = kVAlignTop + kHAlignLeft,
            },

            SetStyle(CreateTextStyle(FontHelp, 20, BlackColor)),
            Text
            {
                x=x+kTextOffX,
                y=y-30,
                w = 240,
                h = 80,
                label=GetString("customer_description", customer),
                flags = kVAlignTop + kHAlignLeft,
            },
        }
    );
end;


cx1  = 40;  cy1  = 110;
cx2  = 330;  cy2  = 110;
cx3  = 580;  cy3  = 110;
cx4  = 40;  cy4  = 230;
cx5  = 300;  cy5  = 230;
cx6  = 580; cy6  = 230;
cx7  = 40; cy7  = 350;
cx8  = 280; cy8  = 350;
cx9  = 280; cy9  = 470;
cx10 = 580; cy10 = 350;

MakeDialog
{
    CDPanelHelp4
    {
        x=0,y=0,w=800,h=600,
        name="help4",
        
        customer1x  = cx1,  customer1y  = cy1,
        customer2x  = cx2,  customer2y  = cy2,
        customer3x  = cx3,  customer3y  = cy3,
        customer4x  = cx4,  customer4y  = cy4,
        customer5x  = cx5,  customer5y  = cy5,
        
        customer6x  = cx6,  customer6y  = cy6,
        customer7x  = cx7,  customer7y  = cy7,
        customer8x  = cx8,  customer8y  = cy8,
        customer9x  = cx9,  customer9y  = cy9,
        customer10x = cx10, customer10y = cy10,
        
        Bitmap
        {
            name="helppanel4",
            image="ui/surfaces/fullscreendialog",
            x=0,y=0,w=800,h=600,
            
            -- customers positions:
            
            
            MakeCustomer("1",  cx1,  cy1),
            MakeCustomer("2",  cx2,  cy2),
            MakeCustomer("3",  cx3,  cy3),
            MakeCustomer("4",  cx4,  cy4),
            
            MakeCustomer("5",  cx5,  cy5),
            MakeCustomer("6",  cx6,  cy6),
            MakeCustomer("7",  cx7,  cy7),
            
            MakeCustomer("8",  cx8,  cy8),
            MakeCustomer("9",  cx9,  cy9),
            MakeCustomer("10", cx10, cy10),

			SetStyle(CreateTextStyle(FontGame, 32, RedColor)),
			Text
			{
				x=kCenter,y=10,w=kMax,h=40,
				flags = kVAlignCenter + kHAlignCenter,
				name = "helptitle",
				label= "helptitle",
			},

            --SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
            --CreateText(0, kCenter + 280, "#"..GetString("version",GetConfig(kGameVersion)), 0, 0),
            
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="prev",
                align=kHAlignLeft+kVAlignBottom,
                x=40,y=kMax-10,
                command=
                    function()
                        SwapToModal("scripts/help3.lua");
                    end,
		        SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		        CreateText(2,2,"prev", 0, 0),
		        SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		        CreateText(0,0,"prev", 0, 0),
            },
            
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="done",
                align=kHAlignRight+kVAlignBottom,
                x=kMax-40,y=kMax-10,
                close = true,
                command=
                    function()
                        PlaySound("audio/sfx/menu/switch_screen.ogg");
                        StopMetricTimers();
                    end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"done", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"done", 0, 0),
            },
        },
    },
}

